package jamezo97.clonecraft.item;

import jamezo97.clonecraft.CloneCraftUtils;
import jamezo97.clonecraft.dna.ItemData;
import jamezo97.clonecraft.entity.EntitySpawnEgg;

import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

import org.lwjgl.input.Keyboard;

public class ItemSpawnEgg extends Item{

	Icon inside;

	public ItemSpawnEgg(int par1) {
		super(par1);
		this.setMaxStackSize(64);
	}

	@Override
	public void registerIcons(IconRegister ir) {
	}

	@Override
	public boolean requiresMultipleRenderPasses() {
		return true;
	}

	@Override
	public String getItemDisplayName(ItemStack par1ItemStack) {
		ItemData dna = new ItemData(par1ItemStack);
		return (par1ItemStack.getItemDamage()==1?"":"Unactivated ") + "\247" + CloneCraftUtils.getClosestColourChar(dna.getColour()) + dna.getCurrentEntityName()/*dna.getMixedEntityName()*/ + "\247f Spawn Egg";
	}



	@Override
	public boolean hasEffect(ItemStack par1ItemStack, int pass) {
		if(pass == 1){
			if(par1ItemStack.getItemDamage() == 0){
				return true;
			}
		}
		return false;
	}

	@Override
	public int getColorFromItemStack(ItemStack par1ItemStack, int par2) {
		return new ItemData(par1ItemStack).getColour();
	}

	@Override
	public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
		new ItemData(par1ItemStack).addInfo(par3List, Keyboard.isKeyDown(Keyboard.KEY_LSHIFT));
	}


	@Override
	public Icon getIcon(ItemStack stack, int pass) {
		if(pass == 1){
			return inside;
		}
		return itemIcon;
	}

	public void setIcons(Icon outside, Icon inside){
		this.inside = inside;
		this.itemIcon = outside;
	}



	@Override
	public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
		
		if (par3World.isRemote)
		{
			return true;
		}
		else
		{
			int i1 = par3World.getBlockId(par4, par5, par6);
			par4 += Facing.offsetsXForSide[par7];
			par5 += Facing.offsetsYForSide[par7];
			par6 += Facing.offsetsZForSide[par7];
			double d0 = 0.0D;

			if (par7 == 1 && Block.blocksList[i1] != null && Block.blocksList[i1].getRenderType() == 11)
			{
				d0 = 0.5D;
			}

			Entity entity = new ItemData(par1ItemStack).spawnEntity(par4 + 0.5, par5, par6 + 0.5, par3World);//spawnCreature(par3World, par1ItemStack.getItemDamage(), (double)par4 + 0.5D, (double)par5 + d0, (double)par6 + 0.5D);

			if (entity != null)
			{
				if (entity instanceof EntityLivingBase && par1ItemStack.hasDisplayName())
				{
					((EntityLiving)entity).setCustomNameTag(par1ItemStack.getDisplayName());
				}

				if (!par2EntityPlayer.capabilities.isCreativeMode)
				{
					--par1ItemStack.stackSize;
				}
			}

			return true;
		}
	}

	public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer){
		if (!par2World.isRemote){
			if(par1ItemStack.getItemDamage() == 1){
				

				par2World.playSoundAtEntity(par3EntityPlayer, "random.bow", 0.5F, 0.4F / (itemRand.nextFloat() * 0.4F + 0.8F));


				EntitySpawnEgg e = new EntitySpawnEgg(par2World, par3EntityPlayer, par1ItemStack);
				par2World.spawnEntityInWorld(e);
				e.updateData();

				if (!par3EntityPlayer.capabilities.isCreativeMode)
				{
					--par1ItemStack.stackSize;
				}
				
			}
		}

		return par1ItemStack;
	}

	@Override
	public void getSubItems(int par1, CreativeTabs par2CreativeTabs, List list) {
		Map<Class, String> classToString = (Map<Class, String>)EntityList.classToStringMapping;
		Map<Integer, Class> idToClass = (Map<Integer, Class>)EntityList.IDtoClassMapping;
		for(Entry<Integer, Class> entry : idToClass.entrySet()){
			int id = entry.getKey();
			Class entityClass = entry.getValue();
			if(((EntityLiving.class.isAssignableFrom(entityClass) || isValid(classToString, entityClass))) && !isInvalid(classToString, entityClass)){
				ItemData dna = new ItemData();
				dna.setEntity(id);
				ItemStack egg = new ItemStack(par1, 1, 1);
				dna.save(egg);
				list.add(egg);
			}
		}
		/*int[] customIds = new int[]{CloneCraft.cloneId};
		for(int a = 0; a < customIds.length; a++){
			DNA dna = new DNA();
			dna.addEntity(customIds[a]);
			ItemStack egg = new ItemStack(par1, 1, 1);
			dna.save(egg);
			list.add(egg);
		}*/


	}

	private boolean isInvalid(Map<Class, String> classToString, Class entityClass){
		String name = classToString.get(entityClass);
		if(name != null){
			String[] names = new String[]{"Mob", "Monster"};
			for(int a = 0; a < names.length; a++){
				if(names[a].equals(name)){
					return true;
				}
			}
		}
		return false;
	}

	private boolean isValid(Map<Class, String> classToString, Class entityClass) {
		String name = classToString.get(entityClass);
		if(name != null){
			String[] names = new String[]{"EnderCrystal", "PrimedTnt"};
			for(int a = 0; a < names.length; a++){
				if(names[a].equals(name)){
					return true;
				}
			}
		}
		return false;
	}



}
